% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAfunc.R
\name{mutation}
\alias{mutation}
\title{The default mutation operator in genetic algorithm}
\usage{
mutation(child, prange = NULL, minDist, pchangepoint, lmax, mmax, N)
}
\arguments{
\item{child}{The child chromosome resulting from the \code{crossover} genetic
operator.}

\item{prange}{Default is \code{NULL} for only changepoint detection. If
\code{prange} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{prange}.}

\item{minDist}{The required minimum distance between two adjacent changepoints.}

\item{pchangepoint}{The probability of changepoints for every time series.}

\item{lmax}{The user specified maximum number of changepoints, by default,
as \code{N/2 - 1}.}

\item{mmax}{The user specified maximum length of individual chromosome,
by default, as \code{2+N/2 + 1}.}

\item{N}{The sample size of the time series.}
}
\value{
The resulting child chromosome representation.
}
\description{
In a certain probability, the \code{mutation} genetic operator can be applied
to generate a new \code{child}. By default, the new child selection can be
down by the similar individual selection method in population initialization,
\code{\link{selectTau}}.
}
\details{
A function can apply mutation to the produced child with the specified
probability \code{pmutation} in \code{cptga} and
\code{cptgaisl}. If order selection is not requested
(\code{option = "cp"} in \code{cptga} and \code{cptgaisl}), the default
\code{\link{mutation}} operator function uses \code{selectTau} to select
a completely new individual with a new chromosome as the mutated child.
For details, see \code{\link{selectTau}}. If order selection is needed
(\code{option = "both"} in \code{cptga} and \code{cptgaisl}), we first
decide whether to keep the produced child's model order with a probability
of 0.5. If the child's model order is retained, the \code{selectTau}
function is used to select a completely new individual with a new chromosome
as the mutated child. If a new model order is selected from the candidate
model order set, there is a 0.5 probability to either select a completely new
individual with new changepoint locations or retain the original child's
changepoint locations for the mutated child. Note that the current model
orders in the child's chromosome are excluded from the set to avoid redundant
objective function evaluation. Finally, the function returns a vector
containing the modified chromosomes for mutated \code{child}.
}
