% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.pag}
\alias{plot.pag}
\title{Plot partial ancestral graph (PAG)}
\usage{
\method{plot}{pag}(x, ...)
}
\arguments{
\item{x}{pag object
to be plotted (as outputted from \code{\link{fci}}).}

\item{...}{Currently not in use.}
}
\value{
No return value, the function is called for its side-effects (plotting).
}
\description{
Plot partial ancestral graph (PAG)
}
\examples{
# simulate linear Gaussian data w unobserved variable L1
n <- 100
L1 <- rnorm(n) 
X1 <- rnorm(n)
X2 <- L1 + X1 + rnorm(n)
X3 <- X1 + rnorm(n)
X4 <- X3 + L1 + rnorm(n)
d <- data.frame(p1_X1 = X1,
                p1_X2 = X2,
                p2_X3 = X3,
                p2_X4 = X4)

# use FCI algorithm to recover PAG                
res <- fci(d, test = corTest)

# plot
plot(res)

}
\author{
This code is a modification of the fciAlgo plotting method implemented
in the pcalg package.
}
