% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{catmap.cumulative}
\alias{catmap.cumulative}
\title{catmap: Cumulative Meta-Analysis}
\usage{
catmap.cumulative(catmapobject, fe.forest = FALSE, re.forest = FALSE,
  printout = FALSE)
}
\arguments{
\item{catmapobject}{A catmap object created by \code{\link{catmap}}.}

\item{fe.forest}{A boolean. Toggles whether the forest plot should get saved
to the current working directory.}

\item{re.forest}{A boolean. Toggles whether the forest plot should get saved
to the current working directory.}

\item{printout}{A boolean. Toggles whether a text file of the models
and Q statistic results should get saved to the working directory.}
}
\description{
The \code{catmap.cumulative} conducts cumulative meta-analyses
 and creates plots of Odds Ratios (OR) and Confidence Intervals (CI)
 using a fixed-effects or random-effects model. Note that studies
 should be listed in chronological order in the input file! This
 function does not re-order studies by publication year! Also
 note that random-effects estimates are not defined for a single
 (i.e., the first) study.
}
\examples{
data(catmapdata)
catmapobject <- catmap(catmapdata, 0.95, TRUE)
catmap.cumulative(catmapobject, FALSE, FALSE, FALSE)
}
\seealso{
\code{\link{catmap}}, \code{\link{catmap.forest}},
 \code{\link{catmap.sense}}, \code{\link{catmap.cumulative}},
 \code{\link{catmap.funnel}}
}
\author{
Algorithm designed and implemented by Kristin K. Nicodemus.
 Code modified and updated by Thom Quinn.
}
