% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tavolo.R
\name{tavolo.table}
\alias{tavolo.table}
\title{Create 2 x k frequency tables}
\usage{
\method{tavolo}{table}(df, rev = c("neither", "rows", "columns", "both"),
  ...)
}
\arguments{
\item{df}{a 2 x k frequency table.}

\item{rev}{character string indicating whether to switch row or column order, possible options are "neither", "rows", "columns", or "both". The default is "neither".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{tab}{2 x k frequency table}
}
\description{
Helper function for creating 2 x k frequency tables.
}
\examples{
trial <- data.frame(disease = c(rep("yes", 3), rep("no", 3)),
                    treatment = rep(c("estrogen", "placebo", "other"), 2),
                    count = c(751, 623, 7755, 7479, 9000, 456))

xtabs(count ~ treatment + disease, data = trial) \%>\% tavolo(rev = "columns")
}
