% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tavolo.R
\name{tavolo.data.frame}
\alias{tavolo.data.frame}
\title{Create 2 x k frequency tables}
\usage{
\method{tavolo}{data.frame}(df, x, y, weight = NULL, rev = c("neither",
  "rows", "columns", "both"), ...)
}
\arguments{
\item{df}{a dataframe with binary variable y and categorical variable x.}

\item{x}{categorical predictor/exposure, vector.}

\item{y}{binary outcome, vector.}

\item{weight}{an optional vector of count weights.}

\item{rev}{character string indicating whether to switch row or column order, possible options are "neither", "rows", "columns", or "both". The default is "neither".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{tab}{2 x k frequency table}
}
\description{
Helper function for creating 2 x k frequency tables.
}
\examples{
trial <- data.frame(disease = c(rep("yes", 2), rep("no", 2)),
                    treatment = c(rep(c("estrogen", "placebo"), 2)),
                    count = c(751, 623, 7755, 7479))

tavolo(trial, treatment, disease, count)
}
