% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{validate_cox_input}
\alias{validate_cox_input}
\title{Validate Inputs for Catalytic Cox Model}
\usage{
validate_cox_input(
  formula,
  cat_init,
  tau = NULL,
  tau_seq = NULL,
  init_coefficients = NULL,
  tol = NULL,
  max_iter = NULL,
  cross_validation_fold_num = NULL,
  hazard_beta = NULL,
  tau_alpha = NULL,
  tau_gamma = NULL
)
}
\arguments{
\item{formula}{An object of class \code{formula}. Specifies the model structure for the Cox model, including a \code{Surv} object for survival analysis. Should at least include response variance.}

\item{cat_init}{An initialization object generated by \code{cat_cox_initialization}. This object should contain necessary information about the dataset, including the time and status column names.}

\item{tau}{Optional. A numeric scalar, the regularization parameter for the Cox model. Must be positive.}

\item{tau_seq}{Optional. A numeric vector for specifying a sequence of regularization parameters. Must be positive.}

\item{init_coefficients}{Optional. A numeric vector of initial coefficients for the Cox model. Should match the number of predictors in the dataset.}

\item{tol}{Optional. A positive numeric value indicating the tolerance level for convergence in iterative fitting.}

\item{max_iter}{Optional. A positive integer indicating the maximum number of iterations allowed in the model fitting.}

\item{cross_validation_fold_num}{Optional. A positive integer specifying the number of folds for cross-validation. Should be greater than 1 and less than or equal to the size of the dataset.}

\item{hazard_beta}{Optional. A positive numeric value representing a constant for adjusting the hazard rate in the Cox model.}

\item{tau_alpha}{Optional. A positive numeric value controlling the influence of \code{tau}.}

\item{tau_gamma}{Optional. A positive numeric value controlling the influence of \code{tau_seq}.}
}
\value{
Returns nothing if all checks pass; otherwise, raises an error or warning.
}
\description{
This function validates the parameters provided for setting up a catalytic Cox proportional hazards model
with an initialization object created by \code{cat_cox_initialization}.
}
\details{
This function checks:
\itemize{
\item That \code{tau}, \code{tol}, \code{max_iter}, \code{cross_validation_fold_num}, \code{hazard_beta}, \code{tau_alpha}, and \code{tau_gamma} are positive.
\item That \code{tau_seq} is a non-negative vector.
\item That \code{cat_init} is generated from \code{cat_cox_initialization}.
\item That \code{formula} uses the same time and status column names as those in \code{cat_init}.
\item That \code{init_coefficients} has the correct length for the number of predictors.
\item That \code{cross_validation_fold_num} is between 2 and the dataset size.
\item That the dataset is sufficiently large for cross-validation, recommending fewer folds if it is not.
If any conditions are not met, the function will raise an error or warning.
}
}
