% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{print.cat_bayes}
\alias{print.cat_bayes}
\title{Print Summary of \code{cat_bayes} Model}
\usage{
\method{print}{cat_bayes}(x, digit = 3, detail = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{cat_tune}, typically resulting from a tuning process, including
\code{cat_glm_bayes}, \code{cat_glm_bayes_joint}, \code{cat_cox_bayes} and \code{cat_cox_bayes_joint}.}

\item{digit}{An integer indicating the number of decimal places for printing
coefficient estimates. Default is 3.}

\item{detail}{A logical value indicating whether to include additional detailed output at the end of the summary.
If \code{TRUE}, it will print additional interpretation help.}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
The \code{x} object is returned invisibly.
}
\description{
This function prints a formatted summary of a \code{cat_bayes} model object, displaying
key parameters and settings of the fitted model, including the formula,
covariate dimensions, tau (if applicable), family, and algorithm settings,
as well as the coefficients' summary.
}
\details{
This function provides an organized printout of essential details from a Bayesian
model fit. It includes the model formula, dimensionality of covariates, model
family, Stan algorithm settings, and summary of the model coefficients. If
\code{detail} is set to \code{TRUE}, additional information on interpreting the
output is included.
}
