% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveyDashboard.R
\name{surveyDashboard}
\alias{surveyDashboard}
\title{Survey Dashboard for Camera Trap Data Analysis}
\usage{
surveyDashboard(
  CTtable = NULL,
  recordTable = NULL,
  stationCol = NULL,
  cameraCol = NULL,
  xcol = NULL,
  ycol = NULL,
  crs = NULL,
  setupCol = NULL,
  retrievalCol = NULL,
  hasProblems = FALSE,
  CTdateFormat = "ymd",
  camerasIndependent = NULL,
  speciesCol = "Species",
  recordDateTimeCol = "DateTimeOriginal",
  recordDateTimeFormat = "ymd HMS",
  timeZone = "UTC",
  exclude = NULL
)
}
\arguments{
\item{CTtable}{A data.frame containing the camera trap deployment information.}

\item{recordTable}{A data.frame containing the camera trap records.}

\item{stationCol}{The column name containing the camera trap station ID}

\item{cameraCol}{The column name containing the camera trap IDs (optional, only if 2 or more cameras per station)}

\item{xcol}{The column name containing the X coordinate of the camera trap station.}

\item{ycol}{The column name containing the Y coordinate of the camera trap station.}

\item{crs}{The coordinate reference system (CRS) of the camera trap data. Must be a valid argument to \code{\link[sf]{st_crs}}}

\item{setupCol}{The column name containing the camera trap deployment date (and time).}

\item{retrievalCol}{The column name containing the camera trap retrieval date (optionally date-time).}

\item{hasProblems}{A logical indicating whether there are periods of cameras malfunctioning}

\item{CTdateFormat}{The date format of the camera trap deployment and retrieval date and time (default: "ymd").}

\item{camerasIndependent}{logical. If multiple camera per station, are they independent?}

\item{speciesCol}{The column name containing the species names}

\item{recordDateTimeCol}{The column name containing the record date and time}

\item{recordDateTimeFormat}{The date/time format of \code{recordDateTimeCol}}

\item{timeZone}{Time zone of records in recordTable}

\item{exclude}{Species to be excluded from the data set}
}
\value{
A Shiny dashboard application for camera trap survey data analysis
}
\description{
A comprehensive Shiny dashboard for analyzing camera trap survey data. The dashboard provides 
interactive visualization, data exploration, and analysis tools including:

\itemize{
  \item Data import from CSV files, Wildlife Insights exports, or camtrapDP format
  \item Interactive maps for camera locations and species detections
  \item Species activity pattern analysis
  \item Covariate extraction and analysis tools
  \item Single-species and community occupancy modeling
  \item Spatial prediction capabilities
}
}
\details{
The dashboard includes several major components:

\strong{Data Import & Management:}
\itemize{
  \item CSV file import with column mapping
  \item Wildlife Insights data import (zip, CSV, or directory)
  \item camtrap DP data import
  \item Study area import from shapefile
  \item Save/restore functionality for app state
  \item Export functionality to save data from dashboard
}

\strong{Data Processing:}
\itemize{
  \item Flexible station filtering with multiple criteria
  \item Temporal record filtering with independence criteria
  \item Filtering species records by species name
  \item Automated covariate extraction from local rasters or online 
  elevation data
  \item Covariate correlation analysis with visualization
  \item Species accumulation curves
}

\strong{Basic Analysis:}
\itemize{
  \item Basic summary statistics
  \item Interactive overview and species detection maps
  \item Activity pattern analysis (single species and two-species overlap)
  \item Camera operation visualization
}

\strong{Occupancy Modeling:}
\itemize{
  \item Basic workflow for simple model specification (linear effects)
  \item Support for both unmarked and ubms packages
  \item Automated detection history creation
  \item Model comparison and selection
  \item Response curves and spatial predictions
}

\strong{Community Occupancy Modeling:}
\itemize{
  \item Flexible species selection with filtering
  \item Support for fixed, random, and independent effects
  \item Species-site random effects
  \item Effort handling on detection
  \item MCMC diagnostics and convergence assessment
  \item Species occupancy, richness and PAO predictions
}
}
\note{
\itemize{
  \item Interactive maps with multiple basemap options
  \item Covariate scaling is performed automatically if requested (includes
   automatic scaling of prediction rasters)
  \item The app state can be saved and restored
}

Current limitations include:

- supports only single-season data
- no support for spatial capture-recapture models (or anything related to individual IDs)
}
\examples{

\dontrun{

# Start the dashboard without parameters
# This opens the application with a welcome screen where data can be imported
surveyDashboard()

# Basic usage with minimal parameters

data("camtraps")
data("recordTableSample")

  surveyDashboard(
    CTtable = camtraps,
    recordTable = recordTableSample,
    xcol = "utm_x",
    ycol = "utm_y",
    crs = "epsg:32650",      # = UTM50N
    stationCol = "Station",
    setupCol = "Setup_date",
    retrievalCol = "Retrieval_date",
    CTdateFormat = "dmy"
  )
  }
  
  

}
\author{
Juergen Niedballa
}
