% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_test_MGD.R
\name{adjustAlpha}
\alias{adjustAlpha}
\title{Internal: Multiple testing correction}
\usage{
adjustAlpha(
 .alpha                 = args_default()$.alpha,
 .approach_alpha_adjust = args_default()$.approach_alpha_adjust,
 .nr_comparisons        = args_default()$.nr_comparisons
)
}
\arguments{
\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.approach_alpha_adjust}{Character string. Approach used to adjust the
significance level to accommodate multiple testing.
One of "\emph{none}" or "\emph{bonferroni}". Defaults to "\emph{none}".}

\item{.nr_comparisons}{Integer. The number of comparisons. Defaults to \code{NULL}.}
}
\value{
A vector of (possibly adjusted) significance levels.
}
\description{
Adjust a given significance level \code{.alpha} to accommodate multiple testing.
The following corrections are implemented:
\describe{
\item{\code{none}}{(Default) No correction is done.}
\item{\code{bonferroni}}{A Bonferroni correction is done, i.e., alpha is divided by the
number of comparisons \code{.nr_comparisons}.}
}
}
\keyword{internal}
