% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_marktstammdaten.R
\name{marktstammdaten_gasverbrauch}
\alias{marktstammdaten_gasverbrauch}
\title{List MaStR gas consumption data}
\usage{
marktstammdaten_gasverbrauch(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with MaStR entries.
}
\description{
List MaStR gas consumption data
}
\details{
Returns public gas consumption data from the MaStR.
Official docs: https://github.com/bundesAPI/marktstammdaten-api.
}
\examples{
\dontrun{
marktstammdaten_gasverbrauch(params = list(page = 1, pageSize = 5))
}

}
