% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toast.R
\name{toast}
\alias{toast}
\alias{toast_header}
\title{Toast notifications}
\usage{
toast(
  ...,
  header = NULL,
  icon = NULL,
  id = NULL,
  type = NULL,
  duration_s = 5,
  position = "top-right",
  closable = TRUE
)

toast_header(title, ..., icon = NULL, status = NULL)
}
\arguments{
\item{...}{Body content of the toast. Can be a string, or any HTML elements.
Named arguments will be treated as HTML attributes for the toast container.}

\item{header}{Optional header content. Can be a string, or the result of
\code{\link[=toast_header]{toast_header()}}. If provided, creates a \code{.toast-header} with close button
(if \code{closable = TRUE}).}

\item{icon}{Optional icon element, for example from \code{\link[shiny:icon]{shiny::icon()}},
\code{\link[bsicons:bs_icon]{bsicons::bs_icon()}} or \code{\link[fontawesome:fa]{fontawesome::fa()}}.}

\item{id}{Optional unique identifier for the toast. If \code{NULL}, an ID will be
automatically generated when the toast is shown via \code{\link[=show_toast]{show_toast()}}.
Providing a stable ID allows you to hide the toast later. If a toast with
\code{id} is already visible, that toast is automatically hidden before showing
the new toast with the same \code{id} so that only one toast with a given ID is
shown at once.}

\item{type}{Optional semantic type. One of \code{NULL}, \code{"primary"},
\code{"secondary"}, \code{"success"}, \code{"info"}, \code{"warning"}, \code{"danger"}, \code{"light"},
or \code{"dark"}. Applies appropriate Bootstrap background utility classes
(\verb{text-bg-*}).}

\item{duration_s}{Numeric. Number of seconds after which the toast should
automatically hide. Use \code{0}, or \code{NA} to disable auto-hiding (toast will
remain visible until manually dismissed). Default is \code{5} (5 seconds).}

\item{position}{String or character vector specifying where to position the
toast container. Can be provided in several formats:
\itemize{
\item Kebab-case: \code{"top-left"}, \code{"bottom-right"}, etc.
\item Space-separated: \code{"top left"}, \code{"bottom right"}, etc.
\item Character vector: \code{c("top", "left")}, \code{c("bottom", "right")}, etc.
\item Any order: \code{"left top"} is equivalent to \code{"top left"}
}

Valid vertical positions are \code{"top"}, \code{"middle"}, or \code{"bottom"}. Valid
horizontal positions are \code{"left"}, \code{"center"}, or \code{"right"}. Input is
case-insensitive. Default is \code{"bottom-right"}.}

\item{closable}{Logical. Whether to include a close button. Defaults to
\code{TRUE}. When both \code{duration_s = NA} (or \code{0} or \code{NULL}) and \code{closable = FALSE}, the toast will remain visible until manually hidden via
\code{\link[=hide_toast]{hide_toast()}}. This is useful when the toast contains interactive Shiny UI
elements and you want to manage the toast display programmatically.}

\item{title}{Header text (required).}

\item{status}{Optional status text that appears as small, muted text on the
right side of the header.}
}
\value{
A \code{bslib_toast} object that can be passed to \code{\link[=show_toast]{show_toast()}}.

For \code{toast_header()}: a toast header object that can be used with the
\code{header} argument of \code{toast()}.
}
\description{
Toast notifications are lightweight, temporary messages designed to mimic
push notifications from mobile and desktop operating systems. They are built
on \href{https://getbootstrap.com/docs/5.3/components/toasts/}{Bootstrap 5's toast component}.

bslib includes a complete example of toasts and their many configuration
options:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{shiny::runExample("toast", package = "bslib")
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{toast()}: Create a toast element.

\item \code{toast_header()}: Create a structured toast header with optional icon and
status indicator. Returns a data structure that can be passed to the
\code{header} argument of \code{toast()}.

}}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(bslib)

ui <- page_fluid(
  actionButton("show_simple", "Simple Toast"),
  actionButton("show_header", "Toast with Header")
)

server <- function(input, output, session) {
  observeEvent(input$show_simple, {
    show_toast(
      toast(
        "Operation completed successfully!",
        header = "Success",
        type = "success"
      )
    )
  })

  observeEvent(input$show_header, {
    show_toast(
      toast(
        "Your settings have been saved.",
        header = toast_header(
          title = "Settings Updated",
          status = "just now"
        ),
        type = "success"
      )
    )
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=show_toast]{show_toast()}} to display a toast, \code{\link[=hide_toast]{hide_toast()}} to dismiss a
toast, and \code{\link[=toast_header]{toast_header()}} to create structured headers.

Other Toast components: 
\code{\link{show_toast}()}
}
\concept{Toast components}
