% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize}
\alias{standardize}
\title{standardize: Standardization of Data Matrix}
\usage{
standardize(data)
}
\arguments{
\item{data}{N by P data matrix.}
}
\value{
Returns an item level standardized data matrix.
}
\description{
This function standardizes an N by P data matrix, as is strongly recommended before
using any of the brxx reliability estimation functions
}
\examples{
set.seed(999)
your_data=data.frame(mvrnorm(n=20,mu=c(0,0,0,0,0,0,0),
                            Sigma=matrix(c(4,2,2,2,2,2,2,
                                           2,4,2,2,2,2,2,
                                           2,2,4,2,2,2,2,
                                           2,2,2,4,2,2,2,
                                           2,2,2,2,4,2,2,
                                           2,2,2,2,2,4,2,
                                           2,2,2,2,2,2,4),
                                         nrow=7, ncol=7)))
your_data_miss=matrix(ncol=5,nrow=20)
for (i in 1:20){
for (p in 1:5){
   your_data_miss[i,p]=ifelse(runif(1,0,1)<0.2,NA,your_data[i,p])
 }
}
standardize(your_data_miss)

}
