% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benefit_risk.R
\name{benefit}
\alias{benefit}
\alias{risk}
\alias{br}
\alias{mcda}
\title{Bayesian Benefit Risk}
\usage{
benefit(name, fun, weight)

risk(name, fun, weight)

br(...)

mcda(...)
}
\arguments{
\item{name}{a string indicating the name of the benefit or risk.}

\item{fun}{a utility function which maps a parameter value to a utility
value.}

\item{weight}{the weight of the benefit/risk.}

\item{...}{calls to \code{benefit()}, \code{risk()}, and \code{br_group()} to define the
utility functions and treatment groups.}
}
\value{
A named list with posterior summaries of utility for each group and
the raw posterior utility scores.
}
\description{
Bayesian Benefit Risk
}
\details{
The \code{br()} function allows the user to define an arbitrary number
of "benefits" and "risks".  Each benefit/risk requires a utility
function (\code{fun}) and a weight.  The utility function maps the benefit/risk
parameter to a utility score.  The \code{br_group()} function supplies samples
from the posterior distribution for each benefit risk for a specific
group (e.g. treatment arm).

The \code{br()} function then calculates the posterior distribution of the
overall utility for each group.  The overall utility is a weighted sum of
the utilities for each benefit/risk.

The \code{mcda()} function is the same as \code{br()}, but has extra checks to
ensure that the total weight of all benefits and risks is 1, and that the
utility functions produce values between 0 and 1 for all posterior
samples.
}
\examples{
set.seed(1132)
ilogit <- function(x) 1 / (1 + exp(-x))
out <- mcda(
  benefit("CV", function(x) ilogit(x), weight = .75),
  risk("DVT", function(x) ilogit(- .5 * x), weight = .25),
  br_group(
    label = "PBO",
    CV = rnorm(1e4, .1),
    DVT = rnorm(1e4, .1)
  ),
  br_group(
    label = "TRT",
    CV = rnorm(1e4, 2),
    DVT = rnorm(1e4, 1)
  )
)

out

summary(out, probs = c(.025, .5, .975))
summary(out, reference = "PBO")

plot(out)
plot(out, reference = "PBO")

plot_utility(out)
plot_utility(out, reference = "PBO")
plot_utility(out, stacked = TRUE)
}
