% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_inspection.R
\name{standings}
\alias{standings}
\alias{standings.tournament}
\title{Inspect tournament standings}
\usage{
standings(x, stage = NULL)

\method{standings}{tournament}(x, stage = NULL)
}
\arguments{
\item{x}{A \code{tournament} object.}

\item{stage}{Optional stage identifier.}
}
\value{
Data frame of standings.
}
\description{
Inspect tournament standings
}
\examples{
trn <- tournament(c("A", "B", "C", "D")) |>
  round_robin("groups")

# Enter some results
m <- matches(trn, "groups")
trn <- result(trn, "groups", m$match_id[1], score = c(2, 1))

# View current standings
standings(trn, "groups")
}
