% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_helpers.R
\name{results}
\alias{results}
\title{Fluent tournament batch result entry helper}
\usage{
results(tournament, stage, df, overwrite = FALSE, auto_advance = NULL)
}
\arguments{
\item{tournament}{A \code{tournament} object.}

\item{stage}{Stage identifier containing the matches.}

\item{df}{Data frame with required columns: \code{match}, \code{score1}, \code{score2}.}

\item{overwrite}{Logical; forwards to \code{result(..., overwrite = ...)}.}

\item{auto_advance}{Optional logical override for the final row. If \code{NULL},
defaults to the tournament's \code{auto_advance} setting when present.}
}
\value{
Updated \code{tournament} object.
}
\description{
Convenience wrapper for entering multiple match results for one stage.
}
\examples{
teams <- c("A", "B", "C", "D")
trn <- tournament(teams) |>
  round_robin("groups")

m <- matches(trn, "groups")
trn <- results(trn, "groups", data.frame(
  match  = m$match_id,
  score1 = c(2, 1, 3),
  score2 = c(1, 2, 0)
))
}
