% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_spec.R
\name{previous_stage}
\alias{previous_stage}
\title{Resolve source stage from the immediately preceding stage}
\usage{
previous_stage()
}
\value{
Sentinel object to be resolved by transition wiring.
}
\description{
Alias for \code{from_previous()} used by the rewritten stage-verb API.
}
\examples{
teams <- paste("Team", LETTERS[1:8])

# Implicit: defaults to previous_stage()
trn <- tournament(teams) |>
  swiss("open", rounds = 3) |>
  single_elim("playoffs", take = top_n(4))

# Explicit: useful for branching
trn <- tournament(teams) |>
  round_robin("groups") |>
  single_elim("finals", from = previous_stage(), take = top_n(2))
}
