% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_distribution.R
\name{negative_binomial_distribution}
\alias{negative_binomial_distribution}
\alias{negative_binomial_pdf}
\alias{negative_binomial_lpdf}
\alias{negative_binomial_cdf}
\alias{negative_binomial_lcdf}
\alias{negative_binomial_quantile}
\alias{negative_binomial_find_lower_bound_on_p}
\alias{negative_binomial_find_upper_bound_on_p}
\alias{negative_binomial_find_minimum_number_of_trials}
\alias{negative_binomial_find_maximum_number_of_trials}
\title{Negative Binomial Distribution Functions}
\usage{
negative_binomial_distribution(successes, success_fraction)

negative_binomial_pdf(x, successes, success_fraction)

negative_binomial_lpdf(x, successes, success_fraction)

negative_binomial_cdf(x, successes, success_fraction)

negative_binomial_lcdf(x, successes, success_fraction)

negative_binomial_quantile(p, successes, success_fraction)

negative_binomial_find_lower_bound_on_p(trials, successes, alpha)

negative_binomial_find_upper_bound_on_p(trials, successes, alpha)

negative_binomial_find_minimum_number_of_trials(
  failures,
  success_fraction,
  alpha
)

negative_binomial_find_maximum_number_of_trials(
  failures,
  success_fraction,
  alpha
)
}
\arguments{
\item{successes}{number of successes (successes >= 0)}

\item{success_fraction}{probability of success on each trial (0 <= success_fraction <= 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}

\item{trials}{number of trials}

\item{alpha}{significance level (0 < alpha < 1)}

\item{failures}{number of failures (failures >= 0)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Negative Binomial distribution.
}
\examples{
# Negative Binomial distribution with successes = 5, success_fraction = 0.5
dist <- negative_binomial_distribution(5, 0.5)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
negative_binomial_pdf(3, 5, 0.5)
negative_binomial_lpdf(3, 5, 0.5)
negative_binomial_cdf(3, 5, 0.5)
negative_binomial_lcdf(3, 5, 0.5)
negative_binomial_quantile(0.5, 5, 0.5)

\dontrun{
# Find lower bound on p given 10 trials and 5 successes with 95\% confidence
negative_binomial_find_lower_bound_on_p(10, 5, 0.05)
# Find upper bound on p given 10 trials and 5 successes with 95\% confidence
negative_binomial_find_upper_bound_on_p(10, 5, 0.05)
# Find minimum number of trials to observe 3 failures with success fraction 0.5 at 95\% confidence
negative_binomial_find_minimum_number_of_trials(3, 0.5, 0.05)
# Find maximum number of trials to observe 3 failures with success fraction 0.5 at 95\% confidence
negative_binomial_find_maximum_number_of_trials(3, 0.5, 0.05)
}
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/negative_binomial_dist.html}{Boost Documentation} for more details on the mathematical background.
}
