% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dsqrt}
\alias{dsqrt}
\title{Element-wise square root}
\usage{
dsqrt(N = NULL, X, INCX = 1L)
}
\arguments{
\item{N}{Optional integer giving the number of elements. Defaults to `length(X)`.}

\item{X}{Double-precision vector, matrix or [`bigmemory::big.matrix`] input.}

\item{INCX}{Integer stride for traversing `X`.}
}
\value{
Invisibly returns the modified object `X`.
}
\description{
Applies the square root to each entry of `X` in place, supporting both base R
and [`bigmemory::big.matrix`] inputs.
}
\examples{
vals <- matrix(c(1, 4, 9, 16), 2)
dsqrt(X = vals)
vals

}
