% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_fast.R
\name{big_pls_cox_fast}
\alias{big_pls_cox_fast}
\title{Partial Least Squares Components for Cox Models (fast backend)}
\usage{
big_pls_cox_fast(
  X,
  time,
  status,
  ncomp = 2L,
  control = survival::coxph.control(),
  keepX = NULL
)
}
\arguments{
\item{X}{A numeric matrix or a \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} object containing the predictors.}

\item{time}{Numeric vector of survival times.}

\item{status}{Integer (0/1) vector of event indicators.}

\item{ncomp}{Number of latent components to compute.}

\item{control}{Optional list passed to \code{\link[survival:coxph.control]{survival::coxph.control}}.}

\item{keepX}{Optional integer vector specifying the number of variables to
retain (naive sparsity) in each component. A value of zero keeps all
predictors. If a single integer is supplied it is recycled across
components.}
}
\value{
A list with the computed scores, loadings, weights, scaling information and the
fitted Cox model returned by \code{\link[survival:agreg.fit]{survival::coxph.fit}}.
}
\description{
Compute PLS components for Cox models, using a fast C++ backend for both
in-memory matrices and \code{bigmemory::big.matrix} objects.
}
\references{
Maumy, M., Bertrand, F. (2023). PLS models and their extension for big data.
Joint Statistical Meetings (JSM 2023), Toronto, ON, Canada.

Maumy, M., Bertrand, F. (2023). bigPLS: Fitting and cross-validating
PLS-based Cox models to censored big data. BioC2023 — The Bioconductor
Annual Conference, Dana-Farber Cancer Institute, Boston, MA, USA.
Poster. https://doi.org/10.7490/f1000research.1119546.1

Bastien, P., Bertrand, F., Meyer, N., & Maumy-Bertrand, M. (2015).
Deviance residuals-based sparse PLS and sparse kernel PLS for censored
data. \emph{Bioinformatics}, 31(3), 397–404. \url{doi:10.1093/bioinformatics/btu660}

Bertrand, F., Bastien, P., Meyer, N., & Maumy-Bertrand, M. (2014). PLS
models for censored data. In \emph{Proceedings of UseR! 2014} (p. 152).
}
