% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_notices.R
\name{bid_notice_issue}
\alias{bid_notice_issue}
\title{Create Notice stage from individual telemetry issue}
\usage{
bid_notice_issue(issue, previous_stage = NULL, override = list())
}
\arguments{
\item{issue}{A single row from bid_telemetry() output or issues tibble}

\item{previous_stage}{Optional previous BID stage (typically from bid_interpret)}

\item{override}{List of values to override from the issue (problem, evidence, theory)}
}
\value{
A bid_stage object in the Notice stage
}
\description{
Bridge function that converts a single telemetry issue row into a BID Notice stage.
This allows seamless integration between telemetry analysis and the BID framework.
}
\examples{
\dontrun{
issues <- bid_telemetry("data.sqlite")
interpret <- bid_interpret("How can we reduce user friction?")

# Convert first issue to Notice stage
notice <- bid_notice_issue(issues[1, ], previous_stage = interpret)

# Override problem description
notice <- bid_notice_issue(
  issues[1, ],
  previous_stage = interpret,
  override = list(problem = "Custom problem description")
)
}
}
