% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidecar.R
\name{read_sidecar}
\alias{read_sidecar}
\title{Read sidecar JSON files and return metadata as a tidy tibble}
\usage{
read_sidecar(
  x,
  subid = ".*",
  task = ".*",
  run = ".*",
  session = ".*",
  modality = "bold",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{subid}{A regex for matching subject IDs. Default is \code{".*"}.}

\item{task}{A regex for matching tasks. Default is \code{".*"}.}

\item{run}{A regex for matching runs. Default is \code{".*"}.}

\item{session}{A regex for matching sessions. Default is \code{".*"}.}

\item{modality}{A regex for matching modality/kind (e.g. "bold"). Default is \code{"bold"}.
This is matched against the 'kind' field in parsed BIDS filenames.}

\item{full_path}{If TRUE, return full file paths in the \code{file} column. Default is TRUE.}

\item{...}{Additional arguments passed to \code{search_files()}.}
}
\value{
A tibble with one row per JSON file. Columns include:
\itemize{
\item \code{file}: the JSON file path
\item \code{.subid}: subject ID extracted from filename
\item \code{.session}: session ID extracted from filename (if present)
\item \code{.task}: task name extracted from filename (if present)
\item \code{.run}: run number extracted from filename (if present)
\item Additional columns for each top-level key in the JSON files
If no files are found, returns an empty tibble.
}
}
\description{
This function searches for JSON sidecar files matching the given criteria (subject, task, run, session),
reads the JSON content, and converts all top-level fields into columns of a tibble. Each file's metadata
becomes one row in the returned tibble. This is particularly useful for extracting metadata about BIDS
imaging files, such as acquisition parameters, task descriptions, and other relevant information.
}
\examples{
\donttest{
# Read all BOLD sidecar files from a BIDS dataset
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  metadata <- read_sidecar(proj)
  
  # Read sidecar files for a specific subject and task
  sub01_meta <- read_sidecar(proj, 
                            subid="01", 
                            task="balloonanalogrisktask")
  
  # Read sidecar files for anatomical data
  anat_meta <- read_sidecar(proj, 
                           modality="T1w",
                           full_path=FALSE)
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}

}
