% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bids.R
\name{decode_bids_entities}
\alias{decode_bids_entities}
\title{Decode BIDS entities back into a filename}
\usage{
decode_bids_entities(entities)
}
\arguments{
\item{entities}{A named list of BIDS entities (from \code{\link{encode}}).}
}
\value{
A character string representing the BIDS filename.
}
\description{
This function reconstructs a BIDS filename from parsed entities, using the
standard BIDS entity ordering.
}
\examples{
# Parse a filename and reconstruct it
entities <- encode("sub-01_task-rest_run-01_bold.nii.gz")
filename <- decode_bids_entities(entities)
print(filename)

# Modify entities and create new filename
entities$desc <- "smooth6mm"
new_filename <- decode_bids_entities(entities)
print(new_filename)
}
