#'
#' @name bcfrailph.control
#' @title Arguments for controlling bcfrailph fits.
#' @description This is used to set various numeric parameters controlling a bcfrailph model fits.
#'
#' @param max.iter Maximum number of outer iterations. The default is 400.
#' @param tol A absolute tolerance for convergence in gamma frailty fit. The default is 1e-04.
#' @param reltol Relative tolerance for convergence in lognormal frailty fit.The default is 1e-06.
#' @param iter.max argument used to control \link{nlminb} fits used.
#' @param trace argument used to control \link{nlminb} fits used.
#' @param abs.tol argument used to control \link{nlminb} fits used.
#' @param rel.tol argument used to control \link{nlminb} fits used.
#' @param x.tol   argument used to control \link{nlminb} fits used.
#' @param eval.max argument used to control \link{nlminb} fits used.
#' @param xf.tol argument used to control \link{nlminb} fits used.
#' @param step.min argument used to control \link{nlminb} fits used.
#' @param step.max argument used to control \link{nlminb} fits used.
#' @param met procedure of optim method used.
#' @return A list of control parameters.
#'
#' @export bcfrailph.control
#'
#' @seealso \code{\link{bcfrailph}},\code{\link{shrgamsp}}
#'
bcfrailph.control<-function (max.iter=400,tol=1e-04,reltol=1e-06,
eval.max=500,iter.max=500,trace=0,abs.tol=1e-20,rel.tol= 1e-10,x.tol=1.5e-8,
xf.tol= 2.2e-14,step.min=1,step.max=1,met=0){
res<-list(max.iter=max.iter,tol=tol,reltol=reltol,
nlminb_control=list(eval.max=eval.max,iter.max=iter.max,
trace=trace,abs.tol=abs.tol,rel.tol=rel.tol,
x.tol=x.tol,xf.tol=xf.tol,step.min=step.min,
step.max=step.max,sing.tol=rel.tol),met=met)
class(res) <- c("bcfrailph.control")
res
}

##
