% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test_b.R
\name{chisq_test_b}
\alias{chisq_test_b}
\alias{independence_b}
\title{Test of independence for 2-way contingency tables}
\usage{
independence_b(
  x,
  sampling_design = "multinomial",
  ROPE,
  prior = "jeffreys",
  prior_shapes,
  CI_level = 0.95,
  seed = 1,
  mc_error = 0.002
)
}
\arguments{
\item{x}{Either a table or a matrix of counts}

\item{sampling_design}{Either "multinomial", "fixed rows", or "fixed columns"}

\item{ROPE}{vector of positive values giving ROPE boundaries for each regression.}

\item{prior}{Either "jeffreys" (Dirichlet(1/2)) or "uniform" (Dirichlet(1)).
This is ignored if prior_shapes is provided.}

\item{prior_shapes}{Either a single positive scalar, in which case a
symmetric Dirichlet is used, or else a matrix matching the dimensions
of x or a vector of length \code{prod(dim(x))}.}

\item{CI_level}{The posterior probability to be contained in the credible
interval.}

\item{seed}{Always set your seed!}

\item{mc_error}{This is the error in probability from the posterior CDF
evaluated at the ROPE bounds. Note that if it is estimated that these
probabilities are between 0.11 and 0.89, the more relaxed value of 0.01 is
used.}
}
\value{
(returned invisible) A list with the following elements:
\itemize{
\item \code{posterior_shapes}: posterior Dirichlet shape parameters
\item \code{posterior_mean}: posterior mean
\item \code{lower_bound}: lower credible interval bounds
\item \code{upper_bound}: upper credible interval bounds
\item \code{individual_ROPE}: Probability that joint probabilities are
in the ROPE around independent probabilities
\item \code{overall_ROPE}: Overall probability of falling in the ROPE
(i.e., all probabilities are near the product of the marginal probabilities)
\item \code{prob_pij_less_than_p_i_times_p_j}: (If multinomial sampling design)
Probabilities that each joint probability is less than the product of
the marginal probabilities
\item \code{prob_p_j_given_i_less_than_p_j}: (If fixed rows or columns sampling design)
Probabilities that each conditional probability is less than the
marginal probabilities
\item \code{prob_direction}: Probability of direction for the joint or
conditional (depending on sampling scheme) probabilities (based on
\code{prob_pij_less_than_p_i_times_p_j} or \code{prob_p_j_given_i_less_than_p_j})
\item \code{BF_for_dependence_vs_independence}: Bayes factor testing
dependence vs. independence (higher values favor dependence, lower values
favor independence)
\item \code{BF_evidence}: Kass and Raftery's interpretation of the
level of evidence of the Bayes factor
}
}
\description{
Test of independence for 2-way contingency tables
}
\details{
For a 2-way contingency table with R rows and C columns, evaluate
the probability that
\itemize{
\item the joint probabilities \eqn{p_{ij}} are all
within the ROPE of \eqn{p_{i\cdot}\times p_{\cdot j}} for \code{sampling_design = "multinomial"}
\item the probabilities \eqn{p_{j|i}} are all
within the ROPE of \eqn{p_{\cdot j}} if \code{sampling_design = "fixed rows"} or
\code{"fixed columns"}
}
}
\examples{
\donttest{
# Generate data
set.seed(2025)
N = 500
nR = 5
nC = 3
dep_probs = 
  extraDistr::rdirichlet(1,rep(2,nR*nC)) |> 
  matrix(nR,nC)

# Multinomial sampling
## Test independence
independence_b(round(N * dep_probs))

## Use other priors
independence_b(round(N * dep_probs),
               prior = "uniform")
independence_b(round(N * dep_probs),
               prior_shapes = 2)
independence_b(round(N * dep_probs),
               prior_shapes = matrix(1:(nR*nC),nR,nC))

# Fixed marginals
independence_b(round(N * dep_probs),
               sampling_design = "rows")
independence_b(round(N * dep_probs),
               sampling_design = "cols")
}


}
\references{
Gunel, Erdogan &  Dickey, James (1974). Bayes factors for independence in contingency tables, Biometrika, 61(3), Pages 545–557, https://doi.org/10.1093/biomet/61.3.545

Kass, R. E., & Raftery, A. E. (1995). Bayes Factors. Journal of the American Statistical Association, 90(430), 773–795.
}
