% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.barrel_ord.R
\name{autoplot.barrel_ord}
\alias{autoplot.barrel_ord}
\title{Autoplot method for barrel_ord objects}
\usage{
\method{autoplot}{barrel_ord}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"barrel_ord"} (a vegan ordination object with attached metadata).}

\item{...}{Additional arguments:
\describe{
\item{group}{Character. Grouping variable in the metadata. (Required)}
\item{data}{Optional species or environmental data for envfit.}
\item{kind}{Type of ellipse: "se" or "sd". Default is "se".}
\item{method}{Covariance method: "classic" or "robust". Default is "classic".}
\item{conf}{Confidence level for ellipses. Default is 0.95.}
\item{geom_type}{"polygon" or "path" for ellipse. Default is "polygon".}
\item{show_arrows}{Logical; whether to show envfit vectors. Default is TRUE.}
\item{show_centroids}{Logical. Default is FALSE.}
\item{show_ellipses}{Logical. Default is TRUE.}
\item{show_labels}{Logical. Label envfit arrows. Default is TRUE.}
\item{p_thresh}{Numeric. Significance threshold for arrows. Default 0.05.}
\item{alpha}{Numeric. Transparency of ellipses. Default is 0.5.}
}}
}
\value{
A ggplot2 object with ordination scores and optional graphical layers.
}
\description{
Generates a ggplot of site scores from a vegan ordination object with optional group ellipses, centroids, and environmental arrows.
This method is designed to work with ordination objects prepared using \code{\link{barrel_prepare}}.
}
\details{
If \code{geom_type = "polygon"}, group colors are mapped to \code{fill} for ellipses. If \code{geom_type = "path"}, group colors are mapped to \code{color}.
The grouping variable must be present in the metadata provided to \code{\link{barrel_prepare}}.
}
\examples{
library(vegan)
data(dune)
data(dune.env)
ord <- rda(dune, scale = TRUE)
ord <- barrel_prepare(ord, dune.env)
ggplot2::autoplot(ord,
  group = "Management", data = dune,
  method = "robust", kind = "sd", geom_type = "polygon", show_arrows = TRUE
)

}
\seealso{
\code{\link{barrel_prepare}}, \code{\link{stat_barrel}}, \code{\link[vegan]{rda}}, \code{\link[vegan]{metaMDS}}
}
