% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_palettes.R
\name{scale_fill_stratpal}
\alias{scale_fill_stratpal}
\title{Stratigraphic fill scale}
\usage{
scale_fill_stratpal(
  palette = c("stratpal_rpg", "stratpal_grays"),
  overrides = NULL,
  allow_na = FALSE,
  na_color = "gray90",
  ...
)
}
\arguments{
\item{palette}{Character string naming which palette to use.
Options are names of palettes in \code{.stratpalettes}.}

\item{overrides}{Optional named character vector of colors to override
entries in the chosen palette.}

\item{allow_na}{Logical. If TRUE, missing categories are filled with
\code{na_color} instead of erroring.}

\item{na_color}{Color to use for missing categories when
\code{allow_na = TRUE}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:scale_manual]{ggplot2::scale_fill_manual()}}.}
}
\value{
A ggplot2 scale object.
}
\description{
A ggplot2 fill scale that uses one of the built-in stratigraphic palettes.
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(factor(cyl), fill = factor(cyl))) +
  geom_bar() +
  scale_fill_stratpal("stratpal_rpg")

# Override one color
scale_fill_stratpal("stratpal_rpg", overrides = c("volcanic" = "orange"))

# Allow missing categories to be filled with gray
scale_fill_stratpal("stratpal_grays", allow_na = TRUE)
}
