% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{am_commit}
\alias{am_commit}
\title{Commit pending changes}
\usage{
am_commit(doc, message = NULL, time = NULL)
}
\arguments{
\item{doc}{An Automerge document}

\item{message}{Optional commit message (character string)}

\item{time}{Optional timestamp (POSIXct). If \code{NULL}, uses current time.}
}
\value{
The document \code{doc} (invisibly)
}
\description{
Commits all pending operations in the current transaction,
creating a new change in the document's history. Commits can
include an optional message (like a git commit message) and
timestamp.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "key", "value")
am_commit(doc, "Add initial data")

# Commit with specific timestamp
am_commit(doc, "Update", Sys.time())

am_close(doc)

}
