% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_class_functions.r
\name{merge_schemas}
\alias{merge_schemas}
\title{Merge relation schemas in given pairs}
\usage{
merge_schemas(x, to_remove, merge_into, ...)
}
\arguments{
\item{x}{a relational schema object, such as a \code{\link{relation_schema}}
or \code{\link{database_schema}} object.}

\item{to_remove}{an integer vector, giving the indices for schemas to be
merged into other schemas, then removed.}

\item{merge_into}{an integer vector of the same length as \code{to_remove},
giving the indices for the schemas into which to merge.}

\item{...}{further arguments passed on to methods.}
}
\value{
An R object of the same class as \code{x}, where the relations have
been merged as indicated.
}
\description{
Generic function that merges pairs of an object's schemas with matching sets
of keys. The remaining schemas contain all the attributes from the schemas
merged into them.
}
\examples{
rs <- relation_schema(
  list(
    a = list(c("a", "b"), list("a")),
    b = list(c("b", "c"), list("b")),
    b.1 = list(c("b", "d"), list("b")),
    d = list(c("d", "e"), list("d", "e"))
  ),
  letters[1:5]
)
ds <- database_schema(
  rs,
  list(
    list("a", "b", "b", "b"),
    list("b.1", "d", "d", "d")
   )
)
merge_schemas(rs, 3, 2) # merging b and b.1
merge_schemas(ds, 3, 2) # also merging their references

# merging a schema into itself just removes it
merge_schemas(rs, 3, 3)
merge_schemas(ds, 3, 3)
}
\seealso{
\code{\link{merge_empty_keys}}, which is based on this function.
}
