% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{d2.database}
\alias{d2.database}
\title{Generate D2 input text to plot databases}
\usage{
\method{d2}{database}(x, name = NA_character_, reference_level = c("attr", "relation"), ...)
}
\arguments{
\item{x}{a \code{\link{database}}.}

\item{name}{a character scalar, giving the name of the schema, if any.}

\item{reference_level}{a character scalar, indicating the format to use for
foreign key references. "relation" only specifies the relations involved;
"attr" also specifies the attributes involved, one pair at a time.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A scalar character, containing text input for D2.
}
\description{
Produces text input for D2 to make a diagram of a given database, usually
rendered with SVG.
}
\details{
Each relation in the database is presented as a set of rows, one for each
attribute in the relation. These rows include information about the attribute
classes.

Any foreign key references are represented by arrows between either the
attribute pairs or the relation pairs, depending on the value of
\code{reference_level}. This allows the output to be geared towards a
specific layout engine. Of the engines currently available for D2, Dagre can
not plot references between relation attributes, just the attributes
themselves, so using \code{reference_level = "relation"} prevents compound
foreign keys resulting in duplicate reference arrows. ELK and Tala
can plot between relation attributes, so the default \code{reference_level =
"attr"} works as intended.
}
\seealso{
The generic \code{\link{d2}}.
}
