% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_additional.R
\name{anova_sspd_pooled}
\alias{anova_sspd_pooled}
\title{Pooled Split-Split Plot Design ANOVA}
\usage{
anova_sspd_pooled(
  data,
  response,
  main_plot,
  sub_plot,
  sub_sub_plot,
  environment,
  replication,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing combined data}

\item{response}{Name of the response variable}

\item{main_plot}{Name of main plot factor}

\item{sub_plot}{Name of sub-plot factor}

\item{sub_sub_plot}{Name of sub-sub-plot factor}

\item{environment}{Name of environment factor}

\item{replication}{Name of replication factor}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing pooled ANOVA results
}
\description{
Performs pooled ANOVA for SSPD experiments across multiple environments.
}
\examples{
data <- expand.grid(env = c("E1","E2"), rep = 1:3, A = c("A1","A2"), 
                    B = c("B1","B2"), C = c("C1","C2"))
data$yield <- rnorm(nrow(data), 1200, 150)
anova_sspd_pooled(data, "yield", "A", "B", "C", "env", "rep")

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
