% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{argonTable}
\alias{argonTable}
\title{Create a Boostrap 4 table container}
\usage{
argonTable(
  ...,
  cardWrap = FALSE,
  title = NULL,
  headTitles,
  dark = FALSE,
  width = 12
)
}
\arguments{
\item{...}{\link{argonTableItems}.}

\item{cardWrap}{Whether to wrap the table in a card. FALSE by default.}

\item{title}{Card title if any.}

\item{headTitles}{Table header names. Must have the same length as the number of
\link{argonTableItem} in \link{argonTableItems}. Set "" to have an empty title field.}

\item{dark}{Whether to enable dark mode. FALSE by default.}

\item{width}{Table width. 12 by default.}
}
\description{
Build an argon table container
}
\examples{
if (interactive()) {
 library(shiny)
 library(argonR)
 library(argonDash)
 shinyApp(
  ui = argonDashPage(
    navbar = argonDashNavbar(),
    sidebar = argonDashSidebar(id = "mysidebar"),
    header = argonDashHeader(),
    body = argonDashBody(
     argonTable(
      headTitles = c(
       "PROJECT",
       "BUDGET",
       "STATUS",
       "USERS",
       "COMPLETION",
       ""
      ),
      argonTableItems(
       argonTableItem("Argon Design System"),
       argonTableItem(dataCell = TRUE, "$2,500 USD"),
       argonTableItem(
        dataCell = TRUE,
        argonBadge(
         text = "Pending",
         status = "danger"
        )
       ),
       argonTableItem(
        argonAvatar(
         size = "sm",
         src = "images/undraw_profile-pic_fatv.svg"
         )
       ),
       argonTableItem(
        dataCell = TRUE,
        argonProgress(value = 60, status = "danger")
       ),
       argonTableItem(
        argonButton(
         name = "Click me!",
         status = "warning",
         icon = "atom",
         size = "sm"
        )
       )
      )
     )
    ),
    footer = argonDashFooter()
  ),
  server = function(input, output) { }
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
