% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{run_predict}
\alias{run_predict}
\title{Predict binary classification model}
\usage{
run_predict(model, .data, cutoff = 0.5)
}
\arguments{
\item{model}{A model_df. results of fitted model that created by run_models().}

\item{.data}{A tbl_df. The data set to predict the model. It also supports tbl, and data.frame objects.}

\item{cutoff}{numeric. Cut-off that determines the positive from the probability of predicting the positive.}
}
\value{
model_df. results of predicted model.
model_df is composed of tbl_df and contains the following variables.:
\itemize{
\item step : character. The current stage in the model fit process. The result of calling run_predict() is returned as "2.Predicted".
\item model_id : character. Type of fit model.
\item target : character. Name of target variable.
\item is_factor : logical. Indicates whether the target variable is a factor.
\item positive : character. Level of positive class of binary classification.
\item negative : character. Level of negative class of binary classification.
\item fitted_model : list. Fitted model object.
\item predicted : list. Predicted value by individual model. Each value has a predict_class class object.
}
}
\description{
Predict some representative binary classification models.
}
\details{
Supported models are functions supported by the representative model package used in R environment.
The following binary classifications are supported:
\itemize{
\item "logistic" : logistic regression by predict.glm() in stats package.
\item "rpart" : recursive partitioning tree model by predict.rpart() in rpart package.
\item "ctree" : conditional inference tree model by predict() in stats package.
\item "randomForest" : random forest model by predict.randomForest() in randomForest package.
\item "ranger" : random forest model by predict.ranger() in ranger package.
\item "xgboost" : random forest model by predict.xgb.Booster() in xgboost package.
\item "lasso" : random forest model by predict.glmnet() in glmnet package.
}

run_predict() is executed in parallel when predicting by model. 
However, it is not supported in MS-Windows operating system and RStudio environment.
}
\examples{
library(dplyr)

# Divide the train data set and the test data set.
sb <- rpart::kyphosis \%>\%
  split_by(Kyphosis)

# Extract the train data set from original data set.
train <- sb \%>\%
  extract_set(set = "train")

# Extract the test data set from original data set.
test <- sb \%>\%
  extract_set(set = "test")

# Sampling for unbalanced data set using SMOTE(synthetic minority over-sampling technique).
train <- sb \%>\%
  sampling_target(seed = 1234L, method = "ubSMOTE")

# Cleaning the set.
train <- train \%>\%
  cleanse

# ---------------------------------------------------------------------------
# Starting with the examples below, uncomment them and run them. ------------
# ---------------------------------------------------------------------------

## Run the model fitting.
# result <- run_models(.data = train, target = "Kyphosis", positive = "present")
# result

## Run the several kinds model predict by dplyr
# result \%>\%
#   run_predict(test)

}
