% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAgena.R
\docType{class}
\name{Network-class}
\alias{Network-class}
\alias{Network}
\title{BN Network object}
\description{
These represent each network in a BN. Networks consist of nodes and
in a BN model there might be more than one network. These networks can
also be linked to each other with the use of input and output nodes. For such
links, see Model$networkLinks.
}
\section{Fields}{

\describe{
\item{\code{id}}{network id}

\item{\code{name}}{network display name}

\item{\code{description}}{network description}

\item{\code{nodes}}{list of nodes in the network}
}}

\section{Methods}{

\describe{
\item{\code{add_node(newNode)}}{A method to add new Node objects to a Network.
Note that adding a new Node to the network does not automatically add its parents to the network.
You need to add all the parents separately too.}

\item{\code{initialize(id, name = NULL, description = NULL, nodes = NULL)}}{Creates a new Network object, a unique id is required,
other fields are filled with defauls unless specified.}

\item{\code{plot()}}{A method to plot the graphical structure of a BN network.}

\item{\code{remove_node(oldNode)}}{A method to remove an existing Node object from the network.
Note that removing a Node from a network does not automatically remove it from its
previous parent-child relationships in the network. You need to adjust such relationships
separately on the Node level.}
}}

