% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.R
\name{remove_adf_entry}
\alias{remove_adf_entry}
\alias{remove_adf_entry.adf_device}
\alias{remove_adf_entry.virtual_path}
\alias{remove_adf_entry.adf_device.character}
\alias{remove_adf_entry.adf_device.virtual_path}
\title{Remove entry (file / directory) from a virtual ADF device}
\usage{
remove_adf_entry(x, path, flush = FALSE, ...)

\method{remove_adf_entry}{adf_device}(x, path, flush = FALSE, ...)

\method{remove_adf_entry}{virtual_path}(x, path, flush = FALSE, ...)

\method{remove_adf_entry.adf_device}{character}(x, path, flush = FALSE, ...)

\method{remove_adf_entry.adf_device}{virtual_path}(x, path, flush = FALSE, ...)
}
\arguments{
\item{x}{The virtual ADF device from which an entry needs to be deleted or a virtual path pointing
at the entry to be deleted. In case of a virtual device, it should be of class \code{adf_device} which
can be created with \code{\link[=create_adf_device]{create_adf_device()}} or \code{\link[=connect_adf]{connect_adf()}}. In case of a virtual path use
\code{\link[=virtual_path]{virtual_path()}}.}

\item{path}{A \code{character} string or a virtual_path (see \code{\link[=virtual_path]{virtual_path()}})
representing a file or directory you wish to delete. Should be omitted when \code{x} is already a
virtual path.}

\item{flush}{A \code{logical} value. When set to \code{FALSE} (default), only the entry's registry in its
parent directory is removed and its flags in the bitmap block are set to 'available'. The entry's
header data and if the entry is a file, the file data will still linger on the virtual disk.
If you don't want that, set this argument to \code{TRUE}, in that case all file or directory data will
be purged. Note that in the latter case, it won't be possible to recover your deleted file or directory.

See also \code{\link[=salvage_adf_entry]{salvage_adf_entry()}}.}

\item{...}{Ignored}
}
\value{
Returns the device connection
}
\description{
This function removes an entry (file or directory) from a virtual ADF device. At the moment
this function only removes a single entry per call, and in case the entry is a directory,
the directory needs to be empty before it can be removed.
}
\examples{
# Open a connection to a virtual device:
my_device <- demo_adf(write_protected = FALSE)

## List files in directory 'Devs':
list_adf_entries(my_device, "Devs")

## remove the file 'system-configuration' from the virtual device
remove_adf_entry(my_device, "devs/system-configuration")

## List files in directory 'Devs' again:
list_adf_entries(my_device, "Devs")

## close the connection to the virtual device
close(my_device)
}
\author{
Pepijn de Vries
}
