% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_fraction}
\alias{fp_fraction}
\title{Reduce a Factorial Plan by 1/2 Fraction}
\usage{
fp_fraction(dm, formula, remove = TRUE)
}
\arguments{
\item{dm}{A factorial plan table.}

\item{formula}{A formula for the defining relationship.}

\item{remove}{A logical value indicating if the removed columns should be
removed. This setting is sticky: if it is FALSE and  you pipe the result of
this function to another \code{fp_fraction()} call, the columns will be
kept by default.}
}
\value{
A reduced factorial plan table (a \code{factorial.plan} object).
}
\description{
Reduce a Factorial Plan by 1/2 Fraction
}
\examples{
# build a 2^5-2 fractional factorial plan with defining relationships
#   I=ABCD and I=BCDE
fp_design_matrix(5) \%>\%
  fp_fraction(~A*B*C*D) \%>\%
  fp_fraction(~B*C*D*E)
}
\seealso{
\code{\link[=fp_design_matrix]{fp_design_matrix()}}
}
