% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.F.SBC.cv.R
\name{bw.F.SBC.cv}
\alias{bw.F.SBC.cv}
\title{Cross-validation bandwidth selector for \insertCite{bose2022;textual}{WData} kernel distribution estimator}
\usage{
bw.F.SBC.cv(
  y,
  w = function(y) {
     ifelse(y >= 0, y, NA)
 },
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular", "biweight",
    "cosine", "optcosine"),
  lower = IQR(y) * length(y)^(-1/3) * 0.05,
  upper = IQR(y) * length(y)^(-1/3) * 5,
  nh = 200L,
  tol = 0.1 * lower,
  plot = TRUE
)
}
\arguments{
\item{y}{A numeric vector containing the biased sample.}

\item{w}{A function representing the bias function applied to the data points. It must be evaluable and positive in each point of the sample the sample \code{y}. By default, it is set to the length-biased function.}

\item{kernel}{A character string specifying the kernel function. Available options: \code{"gaussian"}, \code{"epanechnikov"}, \code{"rectangular"}, \code{"triangular"}, \code{"biweight"}, \code{"cosine"} and \code{"optcosine"}.}

\item{lower}{Numeric value specifying the lower bound for bandwidth selection. Default is computed based on the interquartile range (IQR) and sample size.}

\item{upper}{Numeric value specifying the upper bound for bandwidth selection. Default is computed based on the interquartile range (IQR) and sample size.}

\item{nh}{An integer specifying the number of points to evaluate the cross-validation function. Default is 200.}

\item{tol}{Tolerance value used to check whether the minimum found lies at the boundaries of the interval; that is, the function will return a warning if the window minimizing the cross-validation function lies within \verb{[lower, lower+tol]} or \verb{[upper-tol, upper]}. Default is 10\% of the lower bound.}

\item{plot}{A logical value indicating whether to plot the cross-validation function. Default is \code{TRUE}.}
}
\value{
The optimal bandwidth based on cross-validation criteria.
}
\description{
This function performs bandwidth selection for \insertCite{bose2022;textual}{WData} kernel distribution estimator using cross-validation criteria. It iterates through a range of bandwidth values and computes the cross-validation score for each bandwidth. The bandwidth that minimizes the cross-validation function is selected as the optimal bandwidth.
}
\details{
The optimal bandwidth is obtained as the one that minimizes the cross-validation function, that is,
\deqn{\widehat{h}_{F, \mathrm{CV}} = \arg \min_{h_{F}>0} \frac{1}{n} \sum_{j=1}^n \left( \frac{\widehat{\mu}_w}{w(Y_j)} \mathbb{I} (y \geq Y_j) - \widehat{F}_{h_{F}, -j}(y)\right)^2 \!\!,
\quad \text{with} \quad \widehat{\mu}_w=n \left(\sum_{i=1}^{n}  \frac{1}{w(Y_i)} \right)^{-1}}
and \eqn{\widehat{F}_{h_{F}, -j}} is the \insertCite{bose2022;textual}{WData} kernel distribution estimator without the observation \eqn{Y_j}.
}
\examples{
bw.F.SBC.cv(shrub.data$Width)
bw.F.SBC.cv(shrub.data$Width, kernel = "epanechnikov")
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=cdf.bd]{cdf.bd}}
}
