% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{Results}
\alias{Results}
\title{Search Results Collection}
\description{
Collection of search results with convenient accessors
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{items}}{List of Result objects}

\item{\code{query}}{Search query}

\item{\code{mode}}{Search mode}

\item{\code{time_ms}}{Execution time in ms}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Results-new}{\code{Results$new()}}
\item \href{#method-Results-length}{\code{Results$length()}}
\item \href{#method-Results-texts}{\code{Results$texts()}}
\item \href{#method-Results-ids}{\code{Results$ids()}}
\item \href{#method-Results-scores}{\code{Results$scores()}}
\item \href{#method-Results-top}{\code{Results$top()}}
\item \href{#method-Results-get}{\code{Results$get()}}
\item \href{#method-Results-foreach}{\code{Results$foreach()}}
\item \href{#method-Results-print}{\code{Results$print()}}
\item \href{#method-Results-clone}{\code{Results$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-new"></a>}}
\if{latex}{\out{\hypertarget{method-Results-new}{}}}
\subsection{Method \code{new()}}{
Create a new Results object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$new(items = list(), query = "", mode = "hybrid", time_ms = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{List of Result objects}

\item{\code{query}}{Search query string}

\item{\code{mode}}{Search mode used}

\item{\code{time_ms}}{Execution time in milliseconds}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-length"></a>}}
\if{latex}{\out{\hypertarget{method-Results-length}{}}}
\subsection{Method \code{length()}}{
Get number of results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$length()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-texts"></a>}}
\if{latex}{\out{\hypertarget{method-Results-texts}{}}}
\subsection{Method \code{texts()}}{
Get all result texts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$texts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of texts
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-ids"></a>}}
\if{latex}{\out{\hypertarget{method-Results-ids}{}}}
\subsection{Method \code{ids()}}{
Get all result IDs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$ids()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of IDs
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-scores"></a>}}
\if{latex}{\out{\hypertarget{method-Results-scores}{}}}
\subsection{Method \code{scores()}}{
Get all scores
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$scores()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Numeric vector of scores
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-top"></a>}}
\if{latex}{\out{\hypertarget{method-Results-top}{}}}
\subsection{Method \code{top()}}{
Get top result
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$top()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Result object or NULL if empty
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-get"></a>}}
\if{latex}{\out{\hypertarget{method-Results-get}{}}}
\subsection{Method \code{get()}}{
Get result by index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$get(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Result object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-foreach"></a>}}
\if{latex}{\out{\hypertarget{method-Results-foreach}{}}}
\subsection{Method \code{foreach()}}{
Iterate over results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$foreach(fn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Function to apply to each result}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-print"></a>}}
\if{latex}{\out{\hypertarget{method-Results-print}{}}}
\subsection{Method \code{print()}}{
Print results summary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Results-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Results-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Results$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
