% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImposeConstraint.R
\name{ImposeConstraint}
\alias{ImposeConstraint}
\alias{AddUnconstrained}
\title{Force a tree to match a constraint}
\usage{
ImposeConstraint(tree, constraint)

AddUnconstrained(constraint, toAdd, asPhyDat = TRUE)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{constraint}{Either an object of class \code{phyDat}, in which case returned
trees will be perfectly compatible with each character in \code{constraint};
or a tree of class \code{phylo}, in which each node in \code{constraint} will occur in
the returned tree.
See \href{https://ms609.github.io/TreeSearch/articles/tree-search.html}{vignette}
for further examples.}

\item{toAdd}{Character vector specifying taxa to add to constraint.}

\item{asPhyDat}{Logical: if \code{TRUE}, return a \code{phyDat} object; if \code{FALSE},
return a matrix.}
}
\value{
\code{ImposeConstraint()} returns a tree of class \code{phylo}, consistent
with \code{constraint}.
}
\description{
Modify a tree such that it matches a specified constraint.
This is at present a somewhat crude implementation that attempts to retain
much of the structure of \code{tree} whilst guaranteeing compatibility with
each entry in \code{constraint}.
}
\section{Functions}{
\itemize{
\item \code{AddUnconstrained()}: Expand a constraint to include unconstrained
taxa.

}}
\examples{
tips <- letters[1:9]
tree <- as.phylo(1, 9, tips)
plot(tree)

constraint <- StringToPhyDat("0000?1111 000111111 0000??110", tips, FALSE)
plot(ImposeConstraint(tree, constraint))
}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{Renumber}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TipTimedTree}()},
\code{\link{TrivialTree}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
