% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuccessiveApproximations.R
\name{SuccessiveApproximations}
\alias{SuccessiveApproximations}
\alias{SuccessiveWeights}
\title{Tree search using successive approximations}
\usage{
SuccessiveApproximations(
  tree,
  dataset,
  outgroup = NULL,
  k = 3,
  maxSuccIter = 20,
  ratchetHits = 100,
  searchHits = 50,
  searchIter = 500,
  ratchetIter = 5000,
  verbosity = 0,
  suboptimal = 0.1
)

SuccessiveWeights(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.
Perhaps load into R using \code{\link[TreeTools]{ReadAsPhyDat}}.
Additive (ordered) characters can be handled using
\code{\link[TreeTools]{Decompose}}.}

\item{outgroup}{if not NULL, taxa on which the tree should be rooted}

\item{k}{Constant for successive approximations, see Farris 1969 p. 379}

\item{maxSuccIter}{maximum iterations of successive approximation}

\item{ratchetHits}{maximum hits for parsimony ratchet}

\item{searchHits}{maximum hits in tree search}

\item{searchIter}{maximum iterations in tree search}

\item{ratchetIter}{maximum iterations of parsimony ratchet}

\item{verbosity}{Integer specifying level of messaging; higher values give
more detailed commentary on search progress. Set to \code{0} to run silently.}

\item{suboptimal}{retain trees that are this proportion less optimal than the optimal tree}
}
\value{
\code{SuccessiveApproximations()} returns a list of class \code{multiPhylo}
containing optimal (and slightly suboptimal, if suboptimal > 0) trees.

\code{SuccessiveWeights()} returns the score of a tree, given the
weighting instructions specified in the attributes of the dataset.
}
\description{
Searches for a tree that is optimal under the Successive Approximations
criterion \insertCite{Farris1969}{TreeSearch}.
}
\references{
\insertAllCited{}
}
\seealso{
Other custom search functions: 
\code{\link{EdgeListSearch}()},
\code{\link{Jackknife}()},
\code{\link{MorphyBootstrap}()}
}
\concept{custom search functions}
\keyword{internal}
