% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_bindings.R
\name{get_target_var}
\alias{get_target_var}
\alias{set_target_var}
\title{Set or return treat_var binding}
\usage{
get_target_var(layer)

set_target_var(layer, target_var)
}
\arguments{
\item{layer}{A \code{tplyr_layer} object}

\item{target_var}{A symbol to perform the analysis on}
}
\value{
For \code{treat_var}, the treatment variable binding of the layer
  object. For \code{set_treat_var}, the modified layer environment.
}
\description{
Set or return treat_var binding
}
\examples{
# Load in pipe
library(magrittr)
iris$Species2 <- iris$Species
lay <- tplyr_table(iris, Species) \%>\%
  group_count(Species) \%>\%
  set_target_var(Species2)
}
