% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneway_ancova.R
\name{power_oneway_ancova}
\alias{power_oneway_ancova}
\title{Power Calculations for a one-way ANCOVA}
\usage{
power_oneway_ancova(
  n = NULL,
  mu = NULL,
  n_cov = 1,
  r2 = NULL,
  sd = 1,
  alpha_level = Superpower_options("alpha_level"),
  beta_level = NULL,
  round_up = TRUE,
  type = "exact"
)
}
\arguments{
\item{n}{Sample size in each condition.}

\item{mu}{Vector specifying mean for each condition.}

\item{n_cov}{Number of covariates.}

\item{r2}{Coefficient of determination (r^2) of the combined covariates.}

\item{sd}{Standard deviation for all conditions (residual SD without covariate adjustment).}

\item{alpha_level}{Alpha level used to determine statistical significance.}

\item{beta_level}{Type II error probability (power/100-1)}

\item{round_up}{Logical indicator for whether to round up the sample size(s) to a whole number. Default is TRUE.}

\item{type}{Sets the method for estimating power. "exact" will use the Shieh (2020) approach while "approx" will use the Keppel (1991) approach.}
}
\value{
dfs = degrees of freedom, 
N = Total sample size,
n = Sample size per group/condition,
n_cov = Number of covariates, 
mu = Mean for each condition,
sd = Standard deviation,
r2 = Coefficient of determination of combined covariates.
alpha_level = Type 1 error probability, 
beta_level = Type 2 error probability,
power = Power of test (1-beta_level\*100%), 
type = Method (Shieh or Keppel) for estimating power
}
\description{
Compute power of ANCOVA omnibus test (power_oneway_ancova) or contrast (power_oneway_ancova) for one-way (single factor), between subjects designs.
}
\section{References}{

Keppel, G. (1991). Design and Analysis A Researcher's Handbook. 3rd Edition. Prentice Hall. Englewood Cliffs, New Jersey. See pages 323 - 324. 
Shieh, G. (2017). Power and sample size calculations for contrast analysis in ANCOVA. Multivariate behavioral research, 52(1), 1-11.
Shieh, G. (2020). Power analysis and sample size planning in ANCOVA designs. Psychometrika, 85(1), 101-120.
}

\examples{
# Example from Table 1 Shieh 2020
power_oneway_ancova(mu = c(400, 450, 500), n = c(21,21,21),
r2 = .1^2, sd = 100)
}
