% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{sm_create_dtm}
\alias{sm_create_dtm}
\title{Create Document-Term Matrix}
\usage{
sm_create_dtm(word_counts, min_term_freq = 3, max_term_freq = 0.5)
}
\arguments{
\item{word_counts}{A data.frame with columns doc_id, stem, and n, typically
produced by sm_preprocess_text().}

\item{min_term_freq}{Minimum number of documents a term must appear in to
be retained. Default is 3.}

\item{max_term_freq}{Maximum proportion of documents a term can appear in.
Useful for removing ubiquitous terms. Default is 0.5 (50 percent).}
}
\value{
A DocumentTermMatrix object from the tm package.
}
\description{
Converts preprocessed word counts into a document-term matrix suitable
for topic modeling. Filters rare terms and empty documents.
}
\examples{
\dontrun{
processed <- sm_preprocess_text(papers)
dtm <- sm_create_dtm(processed)
}
}
