% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_g_wrappers.R
\name{ishigami_model}
\alias{ishigami_model}
\title{Fast Ishigami Test Function}
\usage{
ishigami_model(x, a = 7, b = 0.1)
}
\arguments{
\item{x}{Numeric matrix with three columns representing the inputs.}

\item{a}{Numeric scalar controlling the nonlinear term.}

\item{b}{Numeric scalar controlling the interaction term.}
}
\value{
Numeric vector of simulator outputs.
}
\description{
C++ implementation of the Ishigami function that is widely used as a
benchmark for Sobol sensitivity indices. The implementation is vectorised and
therefore convenient for Monte Carlo experiments.
}
\examples{
x <- matrix(runif(30, -pi, pi), ncol = 3)
ishigami_model(x)
}
