% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{CustomDistance}
\alias{CustomDistance}
\title{Run a custom distance function on an input data matrix}
\usage{
CustomDistance(my.mat, my.function, ...)
}
\arguments{
\item{my.mat}{A matrix to calculate distance on}

\item{my.function}{A function to calculate distance}

\item{...}{Extra parameters to my.function}
}
\value{
A distance matrix
}
\description{
Run a custom distance function on an input data matrix
}
\examples{
data("pbmc_small")
# Define custom distance matrix
manhattan.distance <- function(x, y) return(sum(abs(x-y)))

input.data <- GetAssayData(pbmc_small, assay.type = "RNA", layer = "scale.data")
cell.manhattan.dist <- CustomDistance(input.data, manhattan.distance)

}
\author{
Jean Fan
}
\concept{utilities}
