% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stLGCP.R
\name{plot_stlgcp}
\alias{plot_stlgcp}
\title{Plot spatio-temporal log-Gaussian Cox process (LGCP) realizations as time-sliced maps}
\usage{
plot_stlgcp(data)
}
\arguments{
\item{data}{A list containing components from a spatio-temporal LGCP model or simulation output:
\describe{
\item{\code{RF}}{A list describing the latent Gaussian random field, with elements
\code{xcoord}, \code{ycoord}, \code{tcoord}, and \code{Z}, where \code{Z}
is a 3D array of intensity (or log-intensity) surfaces over space and time.}
\item{\code{st.lgcp}}{A data frame with columns \code{x}, \code{y}, and \code{t}
giving the spatial and temporal coordinates of observed events.}
}}
}
\value{
A combined \code{ggplot} object displaying up to ten spatial raster maps arranged
in a grid layout (by default, two rows and up to five columns).
Each panel corresponds to one time slice. The function returns the combined plot object.
}
\description{
Produces a sequence of spatial raster maps displaying the evolution of a
simulated or fitted spatio-temporal log-Gaussian Cox process (LGCP) over time.
Each map shows the latent Gaussian random field (intensity surface) at a given
time slice, with the corresponding observed point events overlaid.
This visualization helps interpret temporal evolution and spatial clustering
patterns in simulated or fitted LGCP models.
}
\details{
The function plots up to 10 evenly spaced time slices from the latent intensity field
and overlays the corresponding point events accumulated up to each time point.
Each panel represents a spatial realization at a fixed time \eqn{t_k}, providing
a visual summary of the dynamic spatio-temporal structure of the LGCP.

This approach follows the visualization principles used in Ghorbani et al. (2021, 2025),
where LGCPs are employed to assess the behavior of separability diagnostics and
kernel-based tests in complex, non-separable point process settings.
The raster intensity surfaces illustrate latent heterogeneity, while the overlaid
points display observed event clustering relative to the underlying field.

Time slices are selected at evenly spaced quantiles of the temporal domain, and
each plot includes:
\itemize{
\item A raster map of the latent intensity surface at time \eqn{t_k};
\item White contour lines showing equal-intensity regions;
\item Overlaid black points representing events observed up to \eqn{t_k}.
}

The resulting plots are arranged into a single grid layout using the
\pkg{patchwork} package for ease of comparison.
}
\examples{

# Example: visualize a spatio-temporal LGCP simulation
out <- rstLGCPP(xlim = c(0,1),
                ylim = c(0,1),
                tlim = c(0,1),
                grid = c(15,15,10))
plot_stlgcp(data = out)

}
\references{
Ghorbani M., Vafaei N., Dvořák J., Myllymäki M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics & Data Analysis}, \bold{161}, 107245.
}
\seealso{
\code{\link{Gauss.st.F}} for simulating spatio-temporal Gaussian random fields;
\code{\link{get.lambda.function}} and \code{\link{rstpoispp}}
for generating intensity-based spatio-temporal point processes.
}
\author{
Nafiseh Vafaei \email{nafiseh.vafaei@slu.se}
}
