% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lambda_max.R
\name{get.lambda.max}
\alias{get.lambda.max}
\title{Upper bound for spatio-temporal intensity models}
\usage{
get.lambda.max(
  N,
  g,
  model = 1L,
  mu1 = 0.5,
  sd1 = 0.2,
  mu2 = c(0.5, 0.5),
  sd2 = c(0.2, 0.2),
  mu3 = c(0.3, 0.3, 0.2),
  sd3 = c(0.05, 0.05, 0.05)
)
}
\arguments{
\item{N}{Numeric scalar (> 0). Total expected number of events (baseline intensity level).}

\item{g}{Numeric scalar (>= 0). Weight of the structured (non-separable) component.}

\item{model}{Integer in \code{1:4}. See \code{\link{get.lambda.function}}.}

\item{mu1}{Numeric scalar. Mean of the temporal Gaussian background term (models 2 and 4).}

\item{sd1}{Numeric scalar (> 0). Standard deviation of the temporal Gaussian background term.}

\item{mu2}{Numeric vector of length 2. Mean of the spatial Gaussian background term (models 3 and 4).}

\item{sd2}{Numeric vector of length 2 with positive entries. Standard deviations of the spatial background term.}

\item{mu3}{Numeric vector of length 3. Mean of the structured spatio-temporal Gaussian component.}

\item{sd3}{Numeric vector of length 3 with positive entries. Standard deviations of the structured component.}
}
\value{
Numeric scalar. A conservative upper bound for the selected intensity model.
}
\description{
Computes a practical upper bound for the spatio-temporal intensity models used in
\code{\link{get.lambda.function}}. The bound is intended for thinning/rejection sampling
in simulation routines such as \code{\link{rstpoispp}}.
}
\details{
The bound is computed using analytic maxima of Gaussian density components (at their modes),
which yields a conservative and fast-to-evaluate upper bound when the component functions are
Gaussian product densities.

The intensity models are mixtures of a background term and a structured spatio-temporal Gaussian bump.
This function returns an upper bound obtained by evaluating each Gaussian density component at its mode.
This upper bound is typically sufficient for rejection sampling when generating
realizations of inhomogeneous Poisson or Cox point processes.

If \code{norm2d} and \code{norm3d} in this package are Gaussian product densities (independent components),
then the maxima are available in closed form:
\itemize{
\item \eqn{\max_t \phi(t;\mu,\sigma) = 1/(\sigma\sqrt{2\pi})}
\item \eqn{\max_{x,y} \phi(x;\mu_x,\sigma_x)\phi(y;\mu_y,\sigma_y) = 1/(2\pi\sigma_x\sigma_y)}
\item \eqn{\max_{x,y,t} \prod_{d=1}^3 \phi(\cdot;\mu_d,\sigma_d) = 1/((2\pi)^{3/2}\sigma_x\sigma_y\sigma_t)}
}

If your \code{norm2d}/\code{norm3d} use a different parameterization, this bound should be updated accordingly.
}
\examples{
# Example 1: Homogeneous model (Model 1)
get.lambda.max(N = 200, g = 50, model = 1)

# Example 2: Non-separable spatio-temporal model (Model 4)
get.lambda.max(N = 200, g = 50, model = 4)

}
\references{
Ghorbani, M., Vafaei, N., Dvořák, J., and Myllymäki, M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics and Data Analysis}, \bold{161}, 107245.
}
\seealso{
\code{\link{get.lambda.function}}, \code{\link{rstpoispp}}
}
\author{
Nafiseh Vafaei \email{nafiseh.vafaei@slu.se}\cr
Mohammad Ghorbani \email{mohammad.ghorbani@slu.se}
}
