% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal.R, R/print.optimal.R
\encoding{UTF-8}
\name{optimal}
\alias{optimal}
\alias{print.optimal}
\title{Searching for optimal traits}
\usage{
optimal(
  comm,
  traits = NULL,
  envir = NULL,
  checkdata = TRUE,
  subset.min = 1,
  subset.max = ncol(traits),
  pattern = NULL,
  ro.method = "mantel",
  dist = "euclidean",
  method = "pearson",
  scale = TRUE,
  scale.envir = TRUE,
  ranks = TRUE,
  asym.bin = NULL,
  ord = "metric",
  put.together = NULL,
  na.rm = FALSE,
  notification = TRUE,
  progressbar = FALSE
)

\method{print}{optimal}(x, ...)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as
rows. This matrix can contain either presence/absence or abundance data.
Alternatively comm can be an object of class metacommunity.data, an alternative
way to set all data.frames/matrices. When you use the class metacommunity.data the arguments
traits, envir and put.together must be null. See details.}

\item{traits}{Matrix data of species described by traits, with traits as
columns and species as rows (Default traits = NULL).}

\item{envir}{Environmental variables for each community, with variables as
columns and sampling units as rows (Default envir = NULL).}

\item{checkdata}{Logical argument (TRUE or FALSE) to check if species
sequence in the community data follows the same order as the one in the
trait and if sampling units in the community data follows the same order as the one in the
environmental matrices (Default checkdata = TRUE).}

\item{subset.min}{Minimum of traits in each subset (Default subset.min = 1).}

\item{subset.max}{Maximum of traits in each subset (Default subset.max = ncol(traits)).}

\item{pattern}{Patterns for maximize correlation, "tcap", "tdap",
"tcap.tdap" or "rao" (Default pattern = NULL).}

\item{ro.method}{Method to obtain the correlation, "mantel" or "procrustes"
(Default ro.method = "mantel").}

\item{dist}{Dissimilarity index, as accepted by vegdist: "manhattan",
"euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower",
"altGower", "morisita", "horn", "mountford", "raup" , "binomial" or "chao".}

\item{method}{Correlation method, as accepted by cor: "pearson", "spearman"
or "kendall".}

\item{scale}{Logical argument (TRUE or FALSE) to specify if the traits are
measured on different scales (Default Scale = TRUE). When scale = TRUE traits
are measured on different scales and the matrix T is subjected to
standardization within each trait. When scale = FALSE if traits are measured on
the same scale and the matrix T is not subjected to standardization.
Furthermore, if scale = TRUE the matrix of traits is subjected to
standardization within each trait, and Gower Index is used to calculate the
degree of belonging to the species, and if scale = FALSE the matrix of
traits is not subjected to standardization, and Euclidean distance is
calculated to determine the degree of belonging to the species.}

\item{scale.envir}{Logical argument (TRUE or FALSE) to specify if the
environmental variables are measured on different scales (Default scale =
TRUE). If the enviromental variables are measured on different scales, the
matrix is subjected to centralization and standardization within each
variable.}

\item{ranks}{Logical argument (TRUE or FALSE) to specify if ordinal variables are
convert to ranks (Default ranks = TRUE).}

\item{asym.bin}{Vector listing the asymmetric binary traits, see \code{\link[FD]{gowdis}} (Default asym.bin = NULL).}

\item{ord}{Method to be used for ordinal traits, see \code{\link[FD]{gowdis}} (Default ord = "metric").}

\item{put.together}{List to specify group traits that are added or removed
together (Default put.together = NULL). This argument must be a list, see
examples.}

\item{na.rm}{Logical argument (TRUE or FALSE) to specify if pairwise
deletion of missing observations when computing dissimilarities (Default
na.rm = FALSE).}

\item{notification}{Logical argument (TRUE or FALSE) to specify if
notifications of missing observations are shown (Default notification =
TRUE).}

\item{progressbar}{Logical argument (TRUE or FALSE) to specify if display a
progress bar on the R console (Default progressbar = FALSE).}

\item{x}{An object of class optimal.}

\item{...}{Other parameters for the respective functions.}
}
\value{
\item{Subset}{Subset of traits that maximizes the correlation.}
\item{ro}{Correlation for the subset of traits.}
}
\description{
Maximize trait-convergence assembly patterns (TCAP = roTE), trait-divergence
assembly patterns (TDAP = roXE.T), maximize both trait-divergence assembly
patterns and trait-convergence assembly patterns (TCAP.TDAP = roXE) or
alpha divergence (roRE) For more details, see \code{\link{syncsa}}.
}
\details{
Package \strong{SYNCSA} requires that the species and community sequence in
the data.frame or matrix must be the same for all dataframe/matrices.
The function \code{\link{organize.syncsa}} organizes the data for the functions
of the package, placing the matrices of community, traits and
environmental varibles in the same order. The function
use of function organize.syncsa is not requered for run the functions, but
is recommended. In this way the arguments comm, traits, envir, as well as the argument
put.together, can be specified them as normal arguments or by passing them
with the object returned by the function \code{\link{organize.syncsa}} using, in this
case only the argument comm. Using the object returned by organize.syncsa, the comm argument
is used as an alternative way of entering to set all data.frames/matrices, and therefore
the other arguments (traits, envir, and put.together) must be null.
}
\note{
\strong{IMPORTANT}: The sequence species show up in community data
matrix MUST be the same as they show up in traits matrix. See details and
\code{\link{organize.syncsa}}.
}
\examples{
data(flona)
optimal(flona$community, flona$traits, flona$environment, subset.min = 3,
   subset.max = 5, pattern = "tcap")
optimal(flona$community, flona$traits, flona$environment, subset.min = 3,
   subset.max = 5, pattern = "tdap")
optimal(flona$community, flona$traits, flona$environment, subset.min = 3,
   subset.max = 5, pattern = "tcap.tdap")
put.together <- list(c("fol", "sem"), c("tam", "red"))
put.together
optimal(flona$community, flona$traits, flona$environment, subset.min = 1,
   subset.max = 3, pattern = "tcap", put.together = put.together)
}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587-596.

Pillar, V.D., Duarte, L.d.S., Sosinski, E.E. & Joner, F. (2009).
Discriminating trait-convergence and trait-divergence assembly patterns in
ecological community gradients. Journal of Vegetation Science, 20, 334:348.
}
\seealso{
\code{\link{syncsa}}, \code{\link{organize.syncsa}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
