% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{moranI_full_cpp}
\alias{moranI_full_cpp}
\title{Fast Moran's I with Full Statistics}
\usage{
moranI_full_cpp(expr_matrix, W)
}
\arguments{
\item{expr_matrix}{Numeric matrix (genes x spots)}

\item{W}{Spatial weights matrix (spots x spots), row-standardized}
}
\value{
List containing observed I, expected I, and standard deviation
}
\description{
Computes Moran's I along with expected value and standard deviation
under the null hypothesis. Optimized with Armadillo vectorization.
}
\details{
This function pre-computes all weight matrix statistics once, then
loops over genes efficiently. The main bottleneck is the z * W * z'
computation which is O(n^2) per gene.
}
\keyword{internal}
