% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero_col.R
\name{zero_col}
\alias{zero_col}
\alias{single_col}
\title{Check for empty matrix columns (or rows)}
\usage{
zero_col(x, rows = FALSE, value = 0)

single_col(..., value = 1)
}
\arguments{
\item{x}{Numeric matrix. Sparse matrices from the Matrix package are also supported.}

\item{rows}{Logical; if \code{TRUE} check rows, else columns.}

\item{value}{Numeric target (default \code{0}).}

\item{...}{Passed to \code{zero_col()}.}
}
\value{
Logical vector.
}
\description{
More generally, checks that both row/col sums and sums of absolute
values equal a target.
For \code{value = 0}, this means all entries are zero.
\code{single_col()} is a wrapper with \code{value = 1}, often used to check for
dummy columns/rows with exactly one element that is \code{1}.
}
\details{
Memory usage is reduced by applying \code{abs()} checks only to rows/columns
whose total sum is already the target.
}
\examples{
m <- matrix(c(
  0,  0, 0, 0, 
  1, -1, 0, 0,
  0,  0, 1, 0
), nrow = 3, byrow = TRUE)

zero_col(m)
zero_col(m, rows = TRUE)
single_col(m)
single_col(m, rows = TRUE)

}
