% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shark_read.R
\name{read_shark}
\alias{read_shark}
\title{Read SHARK export files (tab- or semicolon-delimited, plain text or zipped)}
\usage{
read_shark(
  filename,
  delimiters = "point-tab",
  encoding = "utf_8",
  guess_encoding = TRUE,
  value_numeric = TRUE
)
}
\arguments{
\item{filename}{Path to the SHARK export file. Can be a \code{.txt} or \code{.zip} file.
If a zip file is provided, it should contain a file named \code{shark_data.txt}.}

\item{delimiters}{Character. Specifies the delimiter used in the file. Options:
\code{"point-tab"} (tab-separated, default) or \code{"point-semi"} (semicolon-separated).}

\item{encoding}{Character. File encoding. Options: \code{"cp1252"}, \code{"utf_8"}, \code{"utf_16"}, \code{"latin_1"}.
Default is \code{"utf_8"}. If \code{guess_encoding = TRUE}, detected encoding overrides this value.}

\item{guess_encoding}{Logical. If \code{TRUE} (default), automatically detect file encoding.
If \code{FALSE}, the function uses only the user-specified encoding.}

\item{value_numeric}{Logical. If \code{TRUE} (default), attempts to convert the \code{"value"} column
to numeric. If \code{FALSE}, leaves \code{"value"} as-is.}
}
\value{
A data frame containing the parsed contents of the SHARK export file,
or \code{NULL} if the file is empty or could not be read.
}
\description{
Reads tab- or semicolon-delimited SHARK export files with standardized format.
The function can handle plain text files (\code{.txt}) or zip archives (\code{.zip}) containing
a file named \code{shark_data.txt}. It automatically detects and converts column types
and can optionally coerce the \code{"value"} column to numeric. The \code{"sample_date"} column
is converted to \code{Date} if it exists.
}
\details{
This function is robust to file encoding issues. By default (\code{guess_encoding = TRUE}),
it attempts to automatically detect the file encoding and will use it if it differs
from the user-specified \code{encoding}. Automatic detection can be disabled.
}
\examples{
\dontrun{
# Read a plain text SHARK export
df_txt <- read_shark("sharkweb_data.txt")

# Read a SHARK export from a zip archive
df_zip <- read_shark("shark_data.zip")

# Read with explicit encoding and do not convert value
df_custom <- read_shark("shark_data.txt",
                        encoding = "latin_1",
                        guess_encoding = FALSE,
                        value_numeric = FALSE)
}

}
\seealso{
\code{\link[=read_shark_deliv]{read_shark_deliv()}} for reading SHARK Excel delivery files (\code{.xls}/\code{.xlsx}).
}
